import requests
from redis import StrictRedis
from redis_cache import RedisCache

from log_utils import get_logger

logger = get_logger(__name__)
client = StrictRedis(host="localhost", decode_responses=True)
cache = RedisCache(redis_client=client)



@cache.cache()
def search_location_in_openstreetmap(country_code: str, location_string: str):
    """
    Search for location information using OpenStreetMap's Nominatim API.
    """
    headers = {"User-Agent": "sample-app"}
    url = f"https://nominatim.openstreetmap.org/search?q={location_string}&format=json&addressdetails=1&limit=5&countrycodes={country_code}&accept-language=en"

    response = requests.get(url, headers=headers)

    if response.status_code == 200:
        data = response.json()
        if not data:
            return None
        # Extract relevant information from the JSON response
        ret = data[0]["address"]
        ret = {k: v for k, v in ret.items() if not k.startswith("ISO") and k != "country_code"}

        return ret
    else:
        return None